<?php

if (!function_exists('PRKSMSApp_activate')) {
    /**
     * @return void
     */
    function PRKSMSApp_activate()
    {
      
        global $wpdb;
        $wpdb->query("CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}prk_sms_app_newsletter` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `mobile` BIGINT NOT NULL,
                `active` enum('0','1') DEFAULT '1',
                PRIMARY KEY(`id`)
            ) {$wpdb->get_charset_collate()};
        ");

        // $wpdb->query("ALTER TABLE `{$wpdb->prefix}prk_sms_app_newsletter`
        //     ADD UNIQUE KEY `mobile_number` (`mobile`);"
        // );

	    $wpdb->query("CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}prk_sms_app_log` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `title` varchar(100) NOT NULL,
                `message` varchar(100) NOT NULL,
                `status` INT(11) NOT NULL,
                `created_at` DATETIME NOT NULL,
                PRIMARY KEY(`id`)
            ) {$wpdb->get_charset_collate()};
        ");
    }
}

if (!function_exists('PRKSMSApp_deactivation')) {
    /**
     * @return void
     */
    function PRKSMSApp_deactivation()
    {
        global $wpdb;
        $wpdb->query("DROP TABLE `{$wpdb->prefix}prk_sms_app_newsletter`");
        $wpdb->query("DROP TABLE `{$wpdb->prefix}prk_sms_app_log`");
    }
}

/**
 * @return void
 */
function PRKSMSAppAdmin()
{
    add_submenu_page('prk-theme', 'تنظیمات پیامک', 'تنظیمات پیامک', "administrator", 'PRKSMSApp-setting', 'PRKSMSAppAdminSetting');
    add_submenu_page('prk-theme', 'ارسال پیامک', 'ارسال پیامک', "administrator", 'PRKSMSApp-test', 'PRKSMSAppAdminTest');
}

require_once(dirname(__FILE__) . '/includes/functions.php');
require_once dirname(__FILE__) . '/includes/action.php';
require_once dirname(__FILE__) . '/includes/woocommerce-order-tracking.php';
require_once dirname(__FILE__) . '/includes/notify-product-activity.php';
require_once dirname(__FILE__) . '/includes/prk-newsletter.php';


add_action('after_setup_theme','PRKSMSApp_activate');
add_action('switch_theme', 'PRKSMSApp_deactivation');

