<?php namespace PRKSMSApp\Gateways\Classes;

use PRKSMSApp\Gateways\Interfaces\SMSInterface;
use stdClass;

class Melipayamak implements SMSInterface{

    const API_URL = 'https://rest.payamak-panel.com/api/';
    const API_URL_wsdl = 'http://api.payamak-panel.com/post/';

    protected $client;



    private static $instance;


    private $prk_getways_sms_options;

    private $username;

    private $password;

    private $from;

    private $phonebook_id;


    public static function get_instance($prk_getways_options) {
       
        if ( is_null( self::$instance ) ) {
            self::$instance = new self($prk_getways_options);
        }
		
		return self::$instance;
	}

    public function __construct($prk_getways_options)
    {
        $this->prk_getways_sms_options = $prk_getways_options;

        $this->username = $this->prk_getways_sms_options->username;

        $this->password = html_entity_decode($this->prk_getways_sms_options->password);

        $this->from = $this->prk_getways_sms_options->from;

        $this->phonebook_id = $this->prk_getways_sms_options->phonebook_id;

    }

    private function CheckMobileExistInContact($mobile){
        $param = [
            'username' => $this->username,
            'password' => $this->password,
            'GroupIds' => $this->phonebook_id,
            'mobilenumber'=>$mobile,

        ];

        $response = $this->execute_wsdl(self::API_URL_wsdl.'Contacts.asmx/CheckMobileExistInContact',$param);


        if( $response->status == 1 ){

            if(isset($response->data->{0}) && $response->data->{0} == '1'){

                return true;

            }

        }

        return false;

    }

    public function addNumberInPhonebook($mobile){


        if($this->CheckMobileExistInContact($mobile)){
            return;
        }

        $param = [
            'username' => $this->username,
            'password' => $this->password,
            'GroupIds' => $this->phonebook_id,
            'mobilenumber'=>$mobile,
            'firstname'=>'کاربر',
            'lastname'=>'سایت',
            'nickname'=>'',
            'corporation'=>'',
            'phone'=>'',
            'fax'=>'',
            'birthdate'=>'2023-02-09',
            'email'=>'',
            'gender'=>2,
            'province'=>8,
            'city'=>347,
            'address'=>'',
            'postalCode'=>'',
            'additionaldate'=>'2023-02-09',
            'additionaltext'=>'',
            'descriptions'=>''
        ];
      
		$response = $this->execute_wsdl(self::API_URL_wsdl.'Contacts.asmx/AddContact',$param);

        if( $response->status == 1 ){

            if(isset($response->data->{0}) && $response->data->{0} == '1'){

                return $this->responseDate(1,$response->data);

            }

        }



    }


    public function responseDate($status,$data){
        $responseData = new stdClass;

        $responseData->data = false;

        $responseData->status = 0;

        if($status == 1){

            $responseData->status = 1;

            $responseData->data = $data;
    
        }

        return $responseData;

    }



    public function sendBulkSMS($text, $mobiles){


        $param = [
            'username' => $this->username,
            'password' => $this->password,
            'from'=>$this->from,
            'to' => join(";",$mobiles),
            'text' => $text
        ];
      
		return $this->execute(self::API_URL.'SendSMS/SendSMS',$param);
        
    }

    public function sendVerifySMS($parameters, $templateId, $mobile)
	{

        $parameters=array_column($parameters['params'], 'value','name');

        $text = [];

        if (empty($parameters) || empty($templateId) || empty($mobile)) {

            error_log("sms parameter check");

            return '0';

        }

        preg_match_all("/#([a-zA-Z]+)#/",$this->prk_getways_sms_options->sms_text,$matches_variables);

            foreach($matches_variables[1] as $variable){

                if(isset($parameters[strtolower($variable)])){

                    $text[] = $parameters[strtolower($variable)];

                }

            }

		
        $param = [
            'username' => $this->username,
            'password' => $this->password,
            'to' => $mobile,
            'bodyId' => $templateId,
            'text' => join(";",$text)
        ];
      
		return $this->execute(self::API_URL.'SendSMS/BaseServiceNumber',$param);
		
	}




    public function getCredit(){



        $param=[
            'username' => $this->username,
            'password' => $this->password
        ];

        $response = $this->execute(self::API_URL.'SendSMS/GetCredit',$param);

        if(is_object($response) && $response->status = 1){

            $response->data = number_format($response->data, 1);;
            
        }

        return  $response;
        
    }





    protected function execute($url, $data = null)
	{
		
		$fields_string = "";

        $responseData = new stdClass;

        $responseData->data = false;

        $responseData->status = 0;
		
		if (!is_null($data)) {
			
			$fields_string = http_build_query($data);
			
		}
		
		$handle = curl_init();
		
		curl_setopt($handle, CURLOPT_URL, $url);
		
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		
		curl_setopt($handle, CURLOPT_POST, true);
		
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);
		
		
		$response     = json_decode(curl_exec($handle));
		
		$code         = curl_getinfo($handle, CURLINFO_HTTP_CODE);
		
		$curl_errno   = curl_errno($handle);
		
		$curl_error   = curl_error($handle);

		if ($curl_errno) {
			
			throw new \Exception($curl_error);
			
		}
		
		curl_close($handle);
  

        if(is_object($response) && $response->RetStatus = 1){

            $responseData->status = 1;

            $responseData->data = $response->Value;

            
        }

		return $responseData;
		
		
	}






    protected function execute_wsdl($url, $data = null)
	{
		
		$fields_string = "";

        $responseData = new stdClass;

        $responseData->data = false;

        $responseData->status = 0;
		
		if (!is_null($data)) {
			
			$fields_string = http_build_query($data);
			
		}
		
		$handle = curl_init();
		
		curl_setopt($handle, CURLOPT_URL, $url);
		
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		
		curl_setopt($handle, CURLOPT_POST, true);
		
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);
		
		
		$response     = curl_exec($handle);
		
		$code         = curl_getinfo($handle, CURLINFO_HTTP_CODE);
		
		$curl_errno   = curl_errno($handle);
		
		$curl_error   = curl_error($handle);

		if ($curl_errno) {
			
			throw new \Exception($curl_error);
			
		}
		
		curl_close($handle);

        $xml = simplexml_load_string($response);

        $json = json_encode($xml);

        $json_decode = json_decode($json);

        if(is_object($json_decode)){

            $responseData->status = 1;

            $responseData->data = $json_decode;

        }

		return $responseData;
		
		
	}




   

}