<?php

class swip_article_products extends \Elementor\Widget_Base {

	public function get_name() {
		return 'article_products';
	}

	public function get_title() {
		return __( 'اسلایدر تکی محصول', 'prk' );
	}

  public function get_icon() {
    return 'eicon-checkout';
  }

  public function get_categories() {
    return [ 'prk-category' ];
  }

  protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'اسلاید ها', 'plugin-name' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => esc_html__( 'عنوان اسلایدر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'هندزفری مدل ایرپاد پرو Anc' , 'plugin-name' ),
			]
		);
		$repeater->add_control(
			'list_url', [
				'label' => esc_html__( 'لینک اسلایدر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#' , 'plugin-name' ),
			]
		);
		$repeater->add_control(
			'list_orginal', [
				'label' => esc_html__( 'محصول اصل', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater->add_control(
			'list_color',
			[
				'label' => esc_html__( 'رنگ اسلایدر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#2FE382',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-color: {{VALUE}}'
				],
			]
		);


		$repeater->add_control(
			'bg_back1',
			[
				'label' => esc_html__( 'تصویر پترن پس زمینه', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-image: url({{url}})',
				],
			]
		);
		$img_carousel = get_parent_theme_file_uri('/assets/img/article_product.png' );
    $repeater->add_control(
			'list_img',
			[
				'label' => esc_html__( 'تصویر اسلایدر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
						'url' => $img_carousel,
					],
			]
		);
		$this->add_control(
			'list_article',
			[
				'label' => esc_html__( 'لیست اسلاید ها', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => esc_html__( 'اسلایدر#جدید', 'plugin-name' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'setting_sections',
			[
				'label' => esc_html__( 'پیکربندی اسلایدر ها', 'plugin-name' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'auto_played',
			[
				'label' => esc_html__( 'پخش اتوماتیک', 'plugin-name' ),
				'description' => esc_html__( 'پخش اتوماتیک اسلایدها', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'true',
			]
		);
		$this->add_control(
			'border_carousel',
						[
						'label' => esc_html__( 'انحنا دور سکشن', 'plugin-name' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => '11px',
							'selectors' => [
							'{{WRAPPER}} .article_slider' => 'border-radius: {{VALUE}}',
							],
						]
		);
    $this->end_controls_section();


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$auto_played = $settings['auto_played'];

?>
		<?Php if ( $settings['list_article'] ):?>

		<div class="article_slider">

			<div class="swiper-article-slider">

				<div class="swiper-wrapper">

					<?php foreach (  $settings['list_article'] as $item ):?>

            <div class="swiper-slide article elementor-repeater-item-<?php echo esc_attr( $item['_id'] );?>">

							<article class="article_item">

								<div class="thumb-off">
		              <img class="t1 shower" src="<?php echo $item['list_img']['url'];?>" alt="article-slider">
								</div>

								<span class="article_backer"></span>
								<div class="article_orginal">

                  <?php if ($item['list_orginal']): ?>
		                <span>غیر اصــل</span>
								  <?php endif; ?>

								</div>

								<h4><?php echo $item['list_title'];?></h4>
								<a class="product-item-link" href="<?php echo $item['list_url'];?>" target="_blank">مشاهده همه <i class="ri-arrow-left-line"></i></a>

							</article>

            </div>

					<?php endforeach;?>

				</div>

				<div class="swiper-pagination">مشاهده محصول<i class="ri-arrow-left-line"></i></div>

			</div>

		</div>

		<script>
			jQuery(document).ready(function(){
				var swiper = new Swiper('.swiper-article-slider', {
					pagination:{
					el: '.swiper-pagination',
					dynamicBullets: true,
					lazy: true,
					},
					loop: true,
					loopedSlides: 2, //スライドの枚数と同じ値を指定
					<?php if ($auto_played == 'yes')
					{?>
						autoplay: {
						delay: 3500,
						disableOnInteraction: false,
						},

          <?php
				}?>
				});
			});
		</script>

    <?php endif;?>

<?php
		}

}
